// ========================================
// 定数

// パスファインダーの処理
var ADDPATH            = 1; // 追加(合体)
var SUBTRACTPATH       = 2; // 前面オブジェクトで型抜き
var INTERSECTPATH      = 3; // 交差
var EXCLUDEOVERLAPPATH = 4; // 中マド
var MINUSBACK          = 5; // 背面オブジェクトで型抜き

// 実行するファインダー処理
var FINDER = EXCLUDEOVERLAPPATH; // ★★★ここを変更する★★★

// ========================================
// 選択中のオブジェクトリストを前面順に並び替える
// (引数: app.activeDocument.selection [選択中のオブジェクト])
// (戻値: テキストフレームのリスト)
function getObjectOrderFront(sel) {
	var page = app.activeWindow.activePage; // アクティブなページ（スプレッド）を取得
	var items = page.allPageItems; // ページ内のすべてのオブジェクトを取得（レイヤー前面順）
	// ※ ↑
	// ※ たとえば sel[0].index。この index は、レイヤー順ではない（基準は謎）
	// ※ なので比較用として、ソート済みの allPageItems を用意

	var orderList = []; // 並び替え後の選択オブジェクトのリスト

	if (sel.length > 0) { // 選択中のオブジェクトが存在するとき
		for (var i = 0; i < items.length; i++) { // ページ内の全オブジェクト
			for (var j = 0; j < sel.length; j++) { // 選択中のオブジェクトリスト
				if (items[i].id == sel[j].id) { // IDが一致したら
					orderList.push(sel[j]); // 新しく、列に並ばせる
				}
			}
		}
		return orderList; // レイヤー前面順に並び替えたオブジェクトを返す
	}
}
// ========================================
// パスファインダー：追加(合体)
function addPath(back, front) {
	return back.addPath(front);
}
// ========================================
// パスファインダー：前面オブジェクトで切り抜き
// ※ 「前面オブジェクトで切り抜き」だけ、処理を変えてる
function subtractPath(back, front) {
	return front.subtractPath(back); // Indesignの関数
}
// ========================================
// パスファインダー：交差
function intersectPath(back, front) {
	return back.intersectPath(front);
}
// ========================================
// パスファインダー：中マド
function excludeOverlapPath(back, front) {
	return back.excludeOverlapPath(front);
}
// ========================================
// パスファインダー：背面オブジェクトで切り抜き
function minusBack(back, front) {
	return back.minusBack(front); // Indesignの関数
}
// ========================================
// パスファインダーの処理を実行
// 引数：finder＝定数
function executionFinder(finder) {
	switch (finder) {
	case ADDPATH:
		addPath(back, front); // 追加(合体)
		break;
	case SUBTRACTPATH:
		subtractPath(back, front); // 前面オブジェクトで切り抜き
		break;
	case INTERSECTPATH:
		intersectPath(back, front); // 交差
		break;
	case EXCLUDEOVERLAPPATH:
		excludeOverlapPath(back, front); // 中マド
		break;
	case MINUSBACK:
		minusBack(back, front); // 背面オブジェクトで型抜き
		break;
	default:
		alert("パスファインダーの処理方法を確認してください");
	}
}

// ========================================
// メイン処理
// ========================================
var doc = app.activeDocument; // アクティブなドキュメント
var sel = doc.selection; // 選択中のオブジェクト（配列）※順不同（Indexも前面背面）
var list = getObjectOrderFront(sel); // レイヤー前面順に並び替え

try {
	// 最前面オブジェクトを軸に、最背面から順にファインダー処理
	if (list.length >= 2) { // 選択オブジェクトが2つ以上なら
		if ( !(FINDER == SUBTRACTPATH) ) { //前面オブジェクトで型抜き以外なら
			var front = list.shift(); // 最前面オブジェクトを取り出す
			while (list.length > 0) {
				var back = list.pop(); // 最背面オブジェクトを取り出す
				executionFinder(FINDER); // パスファインダー処理を実行
			}
		}
		else { // 前面オブジェクトで型抜きなら　※配列が崩れるので、elseで個別処理
			// 背面から順番にファインダーをかける
			list.reverse(); // 配列の並びを逆に
			var back = list.shift(); // 最背面オブジェクトを取り出す
			while (list.length > 0) {
				var front = list.shift(); // 次の最背面オブジェクトを取り出す
				executionFinder(FINDER); // パスファインダー処理を実行
			}
		}
	}
	else {
		alert("オブジェクト未選択");
	}
}
catch (e) {
	alert("エラー発生: " + e);
}
